﻿//////////////////////////////////////////////
// StringView.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkLog
#include "../Dll/DllDefines.h"

#include "String.h"

// Standards
#include <string>
#include <string_view>

/// Class ------------------------------------

namespace nkLog
{
	class DLL_LOG_EXPORT StringView final
	{
		public :

			// Functions
			// Constructor, destructor
			StringView () = delete ;
			StringView (const char* data) noexcept ;
			StringView (const char* data, unsigned long long size) noexcept ;
			StringView (const String& str) noexcept ;

			// Getters
			const char* getData () const ;
			unsigned long long getSize () const ;

			// Operators
			char operator[] (unsigned long long index) const ;

		public :

			// Inlined constructors
			template <typename T = std::string>
			StringView (const std::string& str) noexcept
			:	_data (str.data()),
				_size ((unsigned long long)str.size())
			{
				// Nothing to do
			}

			template <typename T = std::string_view>
			StringView (std::string_view str) noexcept
			:	_data (str.data()),
				_size ((unsigned long long)str.size())
			{
				// Nothing to do
			}

		public :

			// Inlined conversions
			template <typename T = std::string>
			operator std::string () const
			{
				return std::string(_data, _size) ;
			}

			template <typename T = std::string_view>
			operator std::string_view () const
			{
				return std::string_view(_data, _size) ;
			}

		private :

			// Attributes
			const char* _data ;
			unsigned long long _size ;
	} ;
}